import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(10, 7))

# Define colors
ingredient1_color = 'red'
ingredient2_color = 'blue'
clean_empty_color = 'lightgrey'
hand_empty_color = 'whitesmoke'
text_color = 'black'
cocktail_color = 'purple'

# Add dispensers
ax.add_patch(patches.Rectangle((0.5, 8), 2, 1, edgecolor='black', facecolor=ingredient1_color))
ax.text(1.5, 8.5, 'dispenser_1\n(ingredient1)', color=text_color, ha='center', va='center', fontsize=8)

ax.add_patch(patches.Rectangle((6.5, 8), 2, 1, edgecolor='black', facecolor=ingredient2_color))
ax.text(7.5, 8.5, 'dispenser_2\n(ingredient2)', color=text_color, ha='center', va='center', fontsize=8)

# Add shots
ax.add_patch(patches.Rectangle((0.5, 5), 1, 1, edgecolor='black', facecolor=cocktail_color))
ax.text(1, 5.5, 'shot_1\ncontains cocktail2\nnot clean, not empty', color=text_color, ha='center', va='center', fontsize=8)

ax.add_patch(patches.Rectangle((4.5, 5), 1, 1, edgecolor='black', facecolor=clean_empty_color))
ax.text(5, 5.5, 'shot_2\nclean, empty', color=text_color, ha='center', va='center', fontsize=8)

ax.add_patch(patches.Rectangle((8.5, 5), 1, 1, edgecolor='black', facecolor=clean_empty_color))
ax.text(9, 5.5, 'shot_3\nempty, not clean', color=text_color, ha='center', va='center', fontsize=8)

# Add shaker held by left hand
ax.add_patch(patches.Circle((1, 2), 0.75, edgecolor='black', facecolor=clean_empty_color))
ax.text(1, 2, 'shaker_1\nempty, clean\nunshaken, l1', color=text_color, ha='center', va='center', fontsize=8)

# Add hands
ax.add_patch(patches.Rectangle((0.5, 1), 1, 0.5, edgecolor='black', facecolor=hand_empty_color))
ax.text(1, 1.25, 'left_hand\nholding shaker1', color=text_color, ha='center', va='center', fontsize=8)

ax.add_patch(patches.Rectangle((8.5, 1), 1, 0.5, edgecolor='black', facecolor=hand_empty_color))
ax.text(9, 1.25, 'right_hand\nempty', color=text_color, ha='center', va='center', fontsize=8)

# Add legend
legend_elements = [
    patches.Patch(facecolor=ingredient1_color, edgecolor='black', label='ingredient1'),
    patches.Patch(facecolor=ingredient2_color, edgecolor='black', label='ingredient2'),
    patches.Patch(facecolor=clean_empty_color, edgecolor='black', label='clean, empty'),
    patches.Patch(facecolor=hand_empty_color, edgecolor='black', label='hand empty')
]
ax.legend(handles=legend_elements, loc='upper right', fontsize=8)

# Set limits and hide axes
ax.set_xlim(0, 10)
ax.set_ylim(0, 10)
ax.axis('off')

# Save the figure
plt.savefig('<PATH_REMOVED>')
plt.show()